/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCTextComponent;
import jclass.cell.CellEditorEvent;
import jclass.cell.CellInfo;
import jclass.cell.InitialEvent;
import jclass.cell.KeyModifier;
import jclass.util.JCVector;

public class JCTextField
extends JCTextComponent {
    char echo_char;
    String actionCommand;
    protected JCVector actionListeners = new JCVector(0);
    private static final String base = "textfield";
    private static int nameCounter;
    KeyModifier[] key_modifiers = new KeyModifier[]{new KeyModifier(39, 16), new KeyModifier(37, 16)};

    public JCTextField() {
        this("", 20);
    }

    public JCTextField(String string) {
        this(string, 20);
    }

    public JCTextField(String string, int n) {
        this(string, null, null);
        this.columns = n;
    }

    public JCTextField(String string, Applet applet, String string2) {
        super(applet, string2);
        this.setInsets(new Insets(2, 2, 2, 2));
        if (string2 == null) {
            this.setName(base + nameCounter++);
        }
        this.setText(string);
    }

    public void setText(String string) {
        if (this.getText().equals(string)) {
            return;
        }
        super.setText(string);
    }

    protected void getParameters() {
        super.getParameters();
    }

    public char getEchoChar() {
        return this.echo_char;
    }

    public void setEchoChar(char c) {
        this.echo_char = c;
        this.repaint();
    }

    public String getEchoCharString() {
        if (this.echo_char == '\u0000') {
            return null;
        }
        char[] cArray = new char[]{this.echo_char};
        return new String(cArray);
    }

    public void setEchoCharString(String string) {
        this.echo_char = string != null && string.length() > 0 ? string.charAt(0) : (char)'\u0000';
    }

    public boolean echoCharIsSet() {
        return this.echo_char != '\u0000';
    }

    char[] getOutputChars() {
        if (this.echo_char == '\u0000') {
            return this.getTextChars();
        }
        char[] cArray = new char[this.num_char];
        int n = 0;
        while (n < this.num_char) {
            cArray[n] = this.echo_char;
            ++n;
        }
        return cArray;
    }

    protected String getOutputText() {
        return new String(this.getOutputChars(), 0, this.num_char);
    }

    public int positionToX(int n) {
        if (this.getPeer() == null) {
            return 0;
        }
        this.getDrawingArea(this.rect);
        n = Math.max(0, Math.min(n, this.num_char));
        int n2 = 0;
        char[] cArray = this.getOutputChars();
        switch (this.alignment) {
            case 2: {
                return this.rect.x + this.rect.width - this.fm.charsWidth(cArray, n, this.num_char - n);
            }
            case 1: {
                n2 = (this.rect.width - this.fm.charsWidth(cArray, 0, this.num_char)) / 2;
            }
        }
        return this.rect.x + this.fm.charsWidth(cArray, 0, n) + n2;
    }

    public void showPosition(int n) {
        if (this.getPeer() == null) {
            return;
        }
        int n2 = this.positionToX(n);
        int n3 = this.horiz_origin;
        this.getDrawingArea(this.rect);
        if (this.rect.width == 0 || this.rect.height == 0) {
            return;
        }
        if (n2 < this.horiz_origin + this.rect.x) {
            this.horiz_origin = n2 - this.rect.x - 2;
        } else if (n2 > this.horiz_origin + this.rect.x + this.rect.width) {
            this.horiz_origin = n2 - (this.rect.x + this.rect.width) + 5;
        }
        if (n3 != this.horiz_origin) {
            this.repaint();
        }
        this.cursor_pos = n;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        if (this.actionCommand == null) {
            return "";
        }
        return this.actionCommand;
    }

    public void addActionListener(JCActionListener jCActionListener) {
        this.actionListeners.addUnique(jCActionListener);
    }

    public void removeActionListener(JCActionListener jCActionListener) {
        this.actionListeners.removeElement(jCActionListener);
    }

    final int drawLine(Graphics graphics, String string, int n, int n2) {
        graphics.drawString(string, n, n2);
        return this.fm.stringWidth(string);
    }

    public Dimension getMinimumSize(int n) {
        if (this.getPeer() != null) {
            return new Dimension(n * this.fm.charWidth('N'), this.preferredHeight());
        }
        return super.minimumSize();
    }

    protected void paintComponent(Graphics graphics) {
        this.paintComponent(graphics, this.horiz_origin, this.getOutputText(), this.getDrawingArea(), this.alignment, this.fm, this.isEnabled(), this.getForeground(), this.getBackground(), this.selected_fg, this.selected_bg, this.select_start, this.select_end);
        this.blinkCursor(true);
    }

    protected void paintComponent(Graphics graphics, int n, String string, Rectangle rectangle, int n2, FontMetrics fontMetrics, boolean bl, Color color, Color color2, Color color3, Color color4, int n3, int n4) {
        graphics.translate(-n, 0);
        int n5 = rectangle.x;
        switch (n2) {
            case 1: {
                n5 += (rectangle.width - fontMetrics.stringWidth(string)) / 2;
                break;
            }
            case 2: {
                n5 += rectangle.width - fontMetrics.stringWidth(string);
            }
        }
        if (n3 >= string.length()) {
            n3 = string.length();
        }
        if (n4 >= string.length()) {
            n4 = string.length();
        }
        int n6 = fontMetrics.getHeight();
        int n7 = n6 - fontMetrics.getAscent();
        int n8 = rectangle.y + n6 - n7;
        if (!this.isEnabled()) {
            Color color5 = graphics.getColor();
            graphics.setColor(Color.lightGray.darker().darker());
            graphics.drawString(string, n5, n8);
            graphics.setColor(color5);
        } else if (n3 != n4) {
            if (n3 > 0) {
                n5 += this.drawLine(graphics, string.substring(0, n3), n5, n8);
            }
            int n9 = this.positionToX(n3);
            int n10 = fontMetrics.charsWidth(this.getOutputChars(), n3, n4 - n3);
            graphics.setColor(color4 != null ? color4 : color);
            graphics.fillRect(n9, 0, n10, Math.min(this.size().height, fontMetrics.getHeight() + fontMetrics.getDescent() + fontMetrics.getAscent()));
            graphics.setColor(color3 != null ? color3 : color2);
            n5 += this.drawLine(graphics, string.substring(n3, n4), n5, n8);
            graphics.setColor(this.getForeground());
            this.drawLine(graphics, string.substring(n4), n5, n8);
        } else {
            graphics.drawString(string, n5, n8);
        }
        graphics.translate(n, 0);
    }

    public int pointToPosition(int n, int n2) {
        this.getDrawingArea(this.rect);
        return this.pointToPosition(n, n2, this.getOutputChars(), this.num_char, this.fm, this.rect, this.horiz_origin);
    }

    public int pointToPosition(int n, int n2, char[] cArray, FontMetrics fontMetrics, Rectangle rectangle, int n3) {
        int n4 = cArray.length;
        return this.pointToPosition(n, n2, cArray, n4, fontMetrics, rectangle, n3);
    }

    protected int pointToPosition(int n, int n2, char[] cArray, int n3, FontMetrics fontMetrics, Rectangle rectangle, int n4) {
        int[] nArray = fontMetrics.getWidths();
        this.size();
        switch (this.alignment) {
            case 1: {
                n -= rectangle.x + (rectangle.width - fontMetrics.charsWidth(cArray, 0, n3)) / 2;
                break;
            }
            case 2: {
                n -= rectangle.x + rectangle.width - fontMetrics.charsWidth(cArray, 0, n3) - n4;
                break;
            }
            default: {
                n -= rectangle.x - n4;
            }
        }
        int n5 = 0;
        while (n5 < n3) {
            int n6 = nArray[cArray[n5]];
            if (this.overstrike ? n < n6 : n < n6 / 2) {
                return n5;
            }
            n -= n6;
            ++n5;
        }
        return n3;
    }

    protected void postActionEvent(Event event) {
        String string = this.getActionCommand();
        if (event == null) {
            event = new Event(this, 0, string);
        }
        JCActionEvent jCActionEvent = new JCActionEvent(this, event.id, string, event.modifiers);
        int n = 0;
        while (n < this.actionListeners.size()) {
            ((JCActionListener)this.actionListeners.elementAt(n)).actionPerformed(jCActionEvent);
            ++n;
        }
        this.cell_editor_support.fireStopEditing(new CellEditorEvent(jCActionEvent));
    }

    public boolean keyDown(Event event, int n) {
        if (n == 10) {
            this.postActionEvent(event);
            return true;
        }
        return super.keyDown(event, n);
    }

    public Dimension getPreferredSize(CellInfo cellInfo, Object object) {
        FontMetrics fontMetrics = cellInfo.getFontMetrics();
        String string = (String)object;
        return new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight());
    }

    public void setCursorPosition(InitialEvent initialEvent, CellInfo cellInfo, String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        int n = this.pointToPosition(initialEvent.getX(), initialEvent.getY(), cArray, this.num_char, cellInfo.getFontMetrics(), cellInfo.getDrawingArea(), 0);
        this.setCursorPosition(n);
    }

    public KeyModifier[] getReservedKeys() {
        return this.key_modifiers;
    }
}

